#!perl
use utf8;
use warnings;
use strict;

open FILE, '<:encoding(Windows-1252)', "vim Dark Blue.xml" or die $!;
read FILE, my $xml, -s FILE;
close FILE;

my $MS_GOTHIC = 'ＭＳ ゴシック';
## $MS_GOTHIC = '&#xFF2D;&#xFF33; &#x30B4;&#x30B7;&#x30C3;&#x30AF;'; #ＭＳ ゴシック
## $MS_GOTHIC = 'MeiryoKe_Gothic';
my $FIXED_SYS = 'FixedSys';
my $DEFAULT_FONT_SIZE = '12';

#- <WordsStyle name="****" styleID="*" fgColor="0000FF" bgColor="000040"
#+ <WordsStyle name="****" styleID="*" fgColor="A0FFFF" bgColor="00007F"
$xml =~ s{(<WordsStyle .*)fgColor="0000FF"}
                       {$1fgColor="FFFF01"}g;

#- <WidgetStyle name="Default Style" styleID="32" fgColor="FFFFBF" bgColor="000040" fontName="Consolas" fontStyle="0" fontSize="10" />
#+ <WidgetStyle name="Default Style" styleID="32" fgColor="FFFFFF" bgColor="00007F" fontName="********" fontStyle="0" fontSize="**" />
$xml =~ s{(?<=<WidgetStyle name="Default Style" styleID="32" )fgColor="FFFFBF" bgColor="000040" fontName=".*?" fontStyle=".*?" fontSize=".*?"}
                                                             {fgColor="FFFFFF" bgColor="00007F" fontName="$MS_GOTHIC" fontStyle="0" fontSize="$DEFAULT_FONT_SIZE"};
#- <WordsStyle name="DEFAULT" styleID="*" fgColor="FFFFFF" bgColor="000040" fontName="" fontStyle="1" fontSize="" />
#+ <WordsStyle name="DEFAULT" styleID="*" fgColor="FFFFFF" bgColor="00007F" fontName="" fontStyle="0" fontSize="**" />
$xml =~ s{(<WordsStyle name="DEFAULT" styleID=".+?" )fgColor="FFFFFF" bgColor="000040" fontName="" fontStyle=".*?" fontSize=""}
                                                           {$1fgColor="FFFFFF" bgColor="00007F" fontName="" fontStyle="0" fontSize=""}g;

## <WidgetStyle name="Line number margin" styleID="33" fgColor="FFFFFF" bgColor="000040" fontName="" fontStyle="0" fontSize="" />
#- <WidgetStyle name="Line number margin" styleID="33" fgColor="FFFFFF" bgColor="000040" fontName=""         fontStyle="0" fontSize="" />
#+ <WidgetStyle name="Line number margin" styleID="33" fgColor="FFFFFF" bgColor="7788CC" fontName="********" fontStyle="0" fontSize="" />
$xml =~ s{(?<=<WidgetStyle name="Line number margin" styleID="33" )fgColor="FFFFFF" bgColor="000040" fontName=".*?" fontStyle=".*?" fontSize=".*?"}
                                                                  {fgColor="FFFFFF" bgColor="7788CC" fontName="$MS_GOTHIC"};

#- <WidgetStyle name="Fold margin" styleID="0" fgColor="000040" bgColor="000040" />
#+ <WidgetStyle name="Fold margin" styleID="0" fgColor="00007F" bgColor="000060" />
$xml =~ s{(?<=<WidgetStyle name="Fold margin" styleID="0" )fgColor="000040" bgColor="000040"}
                                                          {fgColor="00007F" bgColor="000060"};

#- fgColor="FFA0A0"
#+ fgColor="FF00FF"
$xml =~ s{fgColor="FFA0A0"}{fgColor="FF00FF"}g;

#- fgColor="80A0FF"
#- fgColor="00FFFF"
$xml =~ s{fgColor="80A0FF"}{fgColor="00FFFF"}g;

#- <WordsStyle name="NUMBER" fgColor="FFFFFF"
#- <WordsStyle name="NUMBER" fgColor="FF00FF"
$xml =~ s{(<WordsStyle name="NUMBER".*?)fgColor="FFFFFF"}{$1fgColor="FF00FF"}g;

#- bgColor="000040"
#+ bgColor="00007F"
$xml =~ s{bgColor="000040"}{bgColor="00007F"}g;

#- fgColor="FFFFFF" bgColor="00007F" fontName="" fontStyle="1"
#+ fgColor="B0B4B4" bgColor="00007F" fontName="" fontStyle="0"
$xml =~ s{fgColor="FFFFFF" bgColor="00007F" fontName="" fontStyle="1"}
         {fgColor="B0B4B4" bgColor="00007F" fontName="" fontStyle="0"}g;

#- bgColor="00007F" fontName="" fontStyle="1"
#+ bgColor="00007F" fontName="" fontStyle="0"
$xml =~ s{bgColor="00007F" fontName="" fontStyle="1"}
         {bgColor="00007F" fontName="" fontStyle="0"}g;

#- <WidgetStyle name="Edge colour" styleID="0" fgColor="80FFFF" />
#+ <WidgetStyle name="Edge colour" styleID="0" fgColor="FFFF00" />
$xml =~ s{(?<=<WidgetStyle name="Edge colour" styleID="0" )fgColor=".+?"}{fgColor="0000F0"}g;

#+ <WidgetStyle name="End of line" styleID="0" fgColor="FFFF00" />
$xml =~ s{(?<=<WidgetStyle name="End of line" styleID="0" )fgColor=".+?"}{fgColor="FFFF00"}
 || $xml =~ s{([ \t]+)(<WidgetStyle name="White space symbol".*?/>)([\r\n]+)}
            {$1$2$3$1<WidgetStyle name="End of line" styleID="0" fgColor="FFFF02" />$3}s;

#- <WidgetStyle name="Current line background colour" styleID="0" bgColor="00007F" />
#+ <WidgetStyle name="Current line background colour" styleID="0" bgColor="0000A0" />
$xml =~ s{(?<=<WidgetStyle name="Current line background colour" styleID="0" )bgColor=".+?"}{bgColor="000090"};

# <LexerType name="diff" desc="DIFF" >
#- <WordsStyle name="DELETED" styleID="5" fgColor="FF8080" ... />
#+ <WordsStyle name="DELETED" styleID="5" fgColor="FF0000" ... />
#- <WordsStyle name="ADDED" styleID="6" fgColor="0080FF" ... />
#+ <WordsStyle name="ADDED" styleID="6" fgColor="00FF00" ... />
$xml =~ s{(?<=<WordsStyle name="DELETED" styleID="5" )fgColor=".+?"}{fgColor="FF0000"};
$xml =~ s{(?<=<WordsStyle name="ADDED" styleID="6" )fgColor=".+?"}{fgColor="00FF00"};

#- <WordsStyle name="PREPROCESSOR" styleID="*" fgColor="FFFFFF"
#- <WordsStyle name="PREPROCESSOR" styleID="*" fgColor="FF0080"
$xml =~ s{(<WordsStyle name="PREPROCESSOR" styleID=".*?" )fgColor="FFFFFF"}{$1fgColor="FF0080"}g;

# <LexerType name="batch" desc="Batch" ext="">
#- <WordsStyle name="VARIABLE" styleID="6" fgColor="FFFFFF" bgColor="000040" fontName="" fontStyle="0" fontSize="" />
#+ <WordsStyle name="VARIABLE" styleID="6" fgColor="00FF00" bgColor="00007F" fontName="" fontStyle="0" fontSize="" />
$xml =~ s{(?<=<WordsStyle name="VARIABLE" styleID="6" )fgColor="FFFFFF"}{fgColor="00FF00"};
#- <WordsStyle name="LABEL" styleID="3" fgColor="80FFFF" bgColor="000040" fontName="" fontStyle="4" fontSize="" />
#+ <WordsStyle name="LABEL" styleID="3" fgColor="00FF00" bgColor="00007F" fontName="" fontStyle="4" fontSize="" />
$xml =~ s{(?<=<WordsStyle name="LABEL" styleID="3" )fgColor="80FFFF"(.*?)fontStyle="4"}{fgColor="00FF00"$1fontStyle="0"};

# <LexerType name="javascript" desc="Javascript" ext="">
#- <WordsStyle name="KEYWORD" styleID="47" fgColor="000080" bgColor="00007F" fontName="" fontStyle="3" fontSize="" keywordClass="instre1" />
#+ <WordsStyle name="KEYWORD" styleID="47" fgColor="00FF00" bgColor="00007F" fontName="" fontStyle="0" fontSize="" keywordClass="instre1" />
$xml =~ s{<WordsStyle name="KEYWORD" styleID="47" fgColor="000080" bgColor="00007F" fontName="" fontStyle="3"}
         {<WordsStyle name="KEYWORD" styleID="47" fgColor="00FF00" bgColor="00007F" fontName="" fontStyle="0"};

#- <WordsStyle name="TYPE WORD" styleID="16" fgColor="8000FF" bgColor="000040"
#- <WordsStyle name="TYPE WORD" styleID="16" fgColor="8000FF" bgColor="00007F"
#+ <WordsStyle name="TYPE WORD" styleID="16" fgColor="00FF00" bgColor="00007F"
$xml =~ s{(<WordsStyle name="TYPE WORD" styleID=".*?" )fgColor="8000FF"(?= bgColor="00007F")}{$1fgColor="00FF00"}g;

#+ <WidgetStyle name="Mark Style 1" styleID="25" bgColor="00FFFF" />
#+ <WidgetStyle name="Mark Style 2" styleID="24" bgColor="FF8000" />
#+ <WidgetStyle name="Mark Style 3" styleID="23" bgColor="FFFF00" />
#+ <WidgetStyle name="Mark Style 4" styleID="22" bgColor="8000FF" />
#+ <WidgetStyle name="Mark Style 5" styleID="21" bgColor="008000" />
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 1" styleID="25" bgColor="00FFFF" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 1" styleID="25"}s;
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 2" styleID="24" bgColor="FF8000" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 2" styleID="24"}s;
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 3" styleID="23" bgColor="FFFF00" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 3" styleID="23"}s;
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 4" styleID="22" bgColor="8000FF" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 4" styleID="22"}s;
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="Mark Style 5" styleID="21" bgColor="008000" />\n$1$2} unless $xml =~ m{<WidgetStyle name="Mark Style 5" styleID="21"}s;

#+ <WidgetStyle name="URL hovered" styleID="0" fgColor="0000FF" />
$xml =~ s{([ \t]*)(</GlobalStyles>)}{$1$1<WidgetStyle name="URL hovered" styleID="0" fgColor="FFFF00" />\n$1$2} unless $xml =~ m{<WidgetStyle name="URL hovered" styleID="0"}s;

# - fgColor="000080" bgColor="00007F"
# + fgColor="00FF00" bgColor="00007F"
$xml =~ s{fgColor="000080" bgColor="00007F"}{fgColor="00FF00" bgColor="00007F"}g;

$xml =~ s{\Q<?xml version="1.0" encoding="Windows-1252" ?>\E}{<?xml version="1.0" encoding="utf-8" ?>};

open FILE, '>:utf8', "!Retro Blue (1).xml";
##open FILE, '>:encoding(Windows-1252)', "!Retro Blue (1).xml";
print FILE $xml;
close FILE;
